import os

import requests
import json
from google.cloud import bigquery
import logging
import datetime
import time


def stream_to_bq(data, table_id=None):
    # Construct a BigQuery client object.
    # table_id = "your-project.your_dataset.your_table"

    client = bigquery.Client()

    errors = client.insert_rows_json(table_id, data)  # Make an API request.
    if errors == []:
        logging.info("new rows added")
    else:
        logging.error("Encountered errors while inserting rows: {}".format(errors))

def poll(data,context):
    table_id = os.getenv("TABLE_ID", "empty_table_id")

    api_response = requests.get(
        url="https://data.stad.gent/api/records/1.0/search/?dataset=bezetting-parkeergarages-real-time&q=&sort=-occupation&facet=name&facet=lastupdate&facet=description&facet=lichtfestival&facet=lf_pr&facet=b_park")
    parking_status = json.loads(api_response.content)

    rows = []
    for parking in parking_status["records"]:
        row = {}
        row["timestamp"] = datetime.datetime.fromisoformat(parking['fields']['lastupdate']).timestamp()
        row["name"] = parking['fields']['name']
        row["id"] = parking["fields"]['id']
        row["url"] = parking["fields"]['urllinkaddress']
        row["total_capacity"] = int(parking['fields']['totalcapacity'])
        row["occupation"] = parking['fields']['occupation']

        rows.append(row)
    logging.info(rows)
    stream_to_bq(rows, table_id=table_id)
    return "ok", 200


if __name__ == '__main__':
    while (True):
        poll("empty request")
        time.sleep(60)