from flask import Flask, render_template
import time
import logging
import pandas as pd
import plotly
import plotly.express as px
import json
from google.cloud import bigquery
import os
import db_dtypes

app = Flask(__name__)


def calculate_pi():
    start = time.time()
    # Initialize denominator
    k = 1

    # Initialize sum
    s = 0

    for i in range(3000000):

        # even index elements are positive
        if i % 2 == 0:
            s += 4 / k
        else:

            # odd index elements are negative
            s -= 4 / k

        # denominator is odd
        k += 2
    end = time.time()
    elapsed = end - start
    logging.warning(f"execution time {elapsed}")
    return s, elapsed


@app.route('/')
def hello_world():  # put application's code here
    return render_template("start.html")


@app.route('/pi')
def slow():
    pi, elapsed = calculate_pi()
    return f'{pi} calculated in {elapsed}s'


@app.route('/parking')
def parking():
    bqclient = bigquery.Client(location="EU")
    full_table_name= os.getenv('FULL_TABLE_NAME')

    # Download query results.
    query_string = f"""
    SELECT
      DATE(timestamp) AS date,
      MAX(occupation) AS max,
      MIN(occupation) AS min,
      name
    FROM
      `{full_table_name}`
    WHERE
      DATE(_PARTITIONTIME) >= CURRENT_DATE()-7
    GROUP BY
      name,
      DATE(timestamp)   
    """

    dataframe = (
        bqclient.query(query_string)
            .result()
            .to_dataframe()
    )
    logging.info(dataframe.head())

    fig = px.bar(dataframe, x='date', y='max', color='name',
                 barmode='group', labels="%", range_y=[0, 100])
    graphJSON = json.dumps(fig, cls=plotly.utils.PlotlyJSONEncoder)
    return render_template('parking.html', graphJSON=graphJSON)


if __name__ == '__main__':
    calculate_pi()
    app.run()
